***********************************************************************
*** Table C1: Results from models using equal weights for global variables ***
***********************************************************************

clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"

regress global_credit_gap pcredit_gdp_gap
predict interak1, res

regress global_hp_gap hp_inc_gap
predict interak2, res

replace global_credit_gap = interak1
replace global_hp_gap = interak2


regress global_credit_gap_equal pcredit_gdp_gap
predict interak3, res

regress global_hp_gap_equal hp_inc_gap
predict interak4, res

replace global_credit_gap_equal = interak3
replace global_hp_gap_equal = interak4


**Column (1)
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
est store p1
predict p1, p
roctab crisis4_12 p1
estadd scalar AUROC = r(area)
estadd scalar Countries = 13
estadd scalar Crisis = 19

**Column (2)
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap_equal global_hp_gap_equal ind_hp_inc_exu ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
est store p2
predict p2, p
roctab crisis4_12 p2
estadd scalar AUROC = r(area)
estadd scalar Countries = 14
estadd scalar Crisis = 19

**Column (3)
logit crisis4_12 dlogreal_pcredit pcredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
est store p3
predict p3, p
roctab crisis4_12 p3
estadd scalar AUROC = r(area)
estadd scalar Countries = 13
estadd scalar Crisis = 19

**Column (4)
logit crisis4_12 dlogreal_pcredit pcredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap_equal global_hp_gap_equal ind_hp_inc_exu ind_credit_gdp_exu wholesale_gap equity_assets i.country_id, robust cluster(period)
est store p4
predict p4, p
roctab crisis4_12 p4
estadd scalar AUROC = r(area)
estadd scalar Countries = 14
estadd scalar Crisis = 23


cd "$outputTables"
esttab p1 p2 p3 p4 using TableC1.tex, se indicate("Country fixed effects = *country_id") drop(_cons) ///
											   order(dlogreal_pcredit pcredit_gdp_gap hcredit_gdp_gap nfecredit_gdp_gap global_credit_gap global_hp_gap global_credit_gap_equal global_hp_gap_equal ind_hp_inc_exu ind_credit_gdp_exu wholesale_gap equity_assets hp_inc_gap gdp_gap ) ///
											   star(* 0.1 ** 0.05 *** 0.01) obslast varwidth(30) wrap nomtitles ///
											   label scalars(Countries) ///
											   nodepvars nonotes replace

											   
